/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

//This is header for DSP DMA API 
//Written by Tsung Fan Shen at CSIE,NCTU 2007
#include "metypes.h"
#define DSP_DMA_GCR       0x000E00  //DSP_DMA_GCR Global Control Register
#define DSP_DMA_GTCR			0x000E01    //DSP_DMA_GTCR Global Timeout Control Register
#define DSP_DMA_GSCR			0x000E02    //DSP_DMA_GSCR Global Software Incompatible Control Register

#define DSP_DMA_CSDP0   	0x000C00    //Channel 0 Source/Destination Parameters Register
#define DSP_DMA_CCR0 	  	0x000C01    //Channel 0 Control Register
#define DSP_DMA_CICR0 		0x000C02    //Channel 0 Interrupt Control Register
#define DSP_DMA_CSR0 	  	0x000C03    //Channel 0 Status Register
#define DSP_DMA_CSSA_L0 	0x000C04    //Channel 0 Source Start Address Register LSB
#define DSP_DMA_CSSA_U0 	0x000C05    //Channel 0 Source Start Address Register MSB
#define DSP_DMA_CDSA_L0 	0x000C06    //Channel 0 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U0 	0x000C07    //Channel 0 Destination Start Address Register MSB
#define DSP_DMA_CEN0 			0x000C08    //Channel 0 Element Number Register
#define DSP_DMA_CFN0 			0x000C09    //Channel 0 Frame Number Register
#define DSP_DMA_CSFI0 		0x000C0A    //Channel 0 Frame Index Register
#define DSP_DMA_CSEI0 		0x000C0B    //Channel 0 Element Index Register
#define DSP_DMA_CSAC0 		0x000C0C    //Channel 0 Source Address Counter Register
#define DSP_DMA_CDAC0 		0x000C0D    //Channel 0 Destination Address Counter Register
#define DSP_DMA_CDEI0 		0x000C0E    //Channel 0 Destination Element Index
#define DSP_DMA_CDFI0 		0x000C0F    //Channel 0 Destination Frame Index

#define DSP_DMA_CSDP1 		0x000C20    //Channel 1 Source/Destination Parameters Register
#define DSP_DMA_CCR1 			0x000C21    //Channel 1 Control Register
#define DSP_DMA_CICR1 		0x000C22    //Channel 1 Interrupt Control Register
#define DSP_DMA_CSR1 		  0x000C23  //Channel 1 Status Register
#define DSP_DMA_CSSA_L1 	0x000C24    //Channel 1 Source Start Address Register LSB
#define DSP_DMA_CSSA_U1 	0x000C25    //Channel 1 Source Start Address Register MSB
#define DSP_DMA_CDSA_L1 	0x000C26    //Channel 1 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U1 	0x000C27    //Channel 1 Destination Start Address Register MSB
#define DSP_DMA_CEN1 			0x000C28    //Channel 1 Element Number Register
#define DSP_DMA_CFN1 			0x000C29    //Channel 1 Frame Number Register
#define DSP_DMA_CSFI1 		0x000C2A    //Channel 1 Frame Index Register
#define DSP_DMA_CSEI1 		0x000C2B    //Channel 1 Element Index Register
#define DSP_DMA_CSAC1 		0x000C2C    //Channel 1 Source Address Counter Register
#define DSP_DMA_CDAC1 		0x000C2D    //Channel 1 Destination Address Counter Register
#define DSP_DMA_CDEI1 		0x000C2E    //Channel 1 Destination Element Index
#define DSP_DMA_CDFI1 		0x000C2F    //Channel 1 Destination Frame Index

#define DSP_DMA_CSDP2 		0x000C40    //Channel 2 Source/Destination Parameters Register
#define DSP_DMA_CCR2 			0x000C41    //Channel 2 Control Register
#define DSP_DMA_CICR2 		0x000C42    //Channel 2 Interrupt Control Register
#define DSP_DMA_CSR2 			0x000C43    //Channel 2 Status Register
#define DSP_DMA_CSSA_L2 	0x000C44    //Channel 2 Source Start Address Register LSB
#define DSP_DMA_CSSA_U2 	0x000C45    //Channel 2 Source Start Address Register MSB
#define DSP_DMA_CDSA_L2 	0x000C46    //Channel 2 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U2 	0x000C47    //Channel 2 Destination Start Address Register MSB
#define DSP_DMA_CEN2 			0x000C48    //Channel 2 Element Number Register
#define DSP_DMA_CFN2 			0x000C49    //Channel 2 Frame Number Register
#define DSP_DMA_CSFI2 		0x000C4A    //Channel 2 Frame Index Register
#define DSP_DMA_CSEI2 		0x000C4B    //Channel 2 Element Index Register
#define DSP_DMA_CSAC2 		0x000C4C    //Channel 2 Source Address Counter Register
#define DSP_DMA_CDAC2 		0x000C4D    //Channel 2 Destination Address Counter Register
#define DSP_DMA_CDEI2 		0x000C4E    //Channel 2 Destination Element Index
#define DSP_DMA_CDFI2 		0x000C4F    //Channel 2 Destination Frame Index

#define DSP_DMA_CSDP3 		0x000C60    //Channel 3 Source/Destination Parameters Register
#define DSP_DMA_CCR3 			0x000C61    //Channel 3 Control Register
#define DSP_DMA_CICR3 		0x000C62    //Channel 3 Interrupt Control Register
#define DSP_DMA_CSR3 			0x000C63    //Channel 3 Status Register
#define DSP_DMA_CSSA_L3 	0x000C64    //Channel 3 Source Start Address Register LSB
#define DSP_DMA_CSSA_U3 	0x000C65    //Channel 3 Source Start Address Register MSB
#define DSP_DMA_CDSA_L3 	0x000C66    //Channel 3 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U3 	0x000C67    //Channel 3 Destination Start Address Register MSB
#define DSP_DMA_CEN3 			0x000C68    //Channel 3 Element Number Register
#define DSP_DMA_CFN3 			0x000C69    //Channel 3 Frame Number Register
#define DSP_DMA_CSFI3 		0x000C6A    //Channel 3 Frame Index Register
#define DSP_DMA_CSEI3 		0x000C6B    //Channel 3 Element Index Register
#define DSP_DMA_CSAC3 		0x000C6C    //Channel 3 Source Address Counter Register
#define DSP_DMA_CDAC3 		0x000C6D    //Channel 3 Destination Address Counter Register
#define DSP_DMA_CDEI3 		0x000C6E    //Channel 3 Destination Element Index
#define DSP_DMA_CDFI3 		0x000C6F    //Channel 3 Destination Frame Index

#define DSP_DMA_CSDP4 		0x000C80    //Channel 4 Source/Destination Parameters Register
#define DSP_DMA_CCR4 			0x000C81    //Channel 4 Control Register
#define DSP_DMA_CICR4 		0x000C82    //Channel 4 Interrupt Control Register
#define DSP_DMA_CSR4 			0x000C83    //Channel 4 Status Register
#define DSP_DMA_CSSA_L4 	0x000C84    //Channel 4 Source Start Address Register LSB
#define DSP_DMA_CSSA_U4 	0x000C85    //Channel 4 Source Start Address Register MSB
#define DSP_DMA_CDSA_L4 	0x000C86    //Channel 4 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U4 	0x000C87    //Channel 4 Destination Start Address Register MSB
#define DSP_DMA_CEN4 			0x000C88    //Channel 4 Element Number Register
#define DSP_DMA_CFN4 			0x000C89    //Channel 4 Frame Number Register
#define DSP_DMA_CSFI4 		0x000C8A    //Channel 4 Frame Index Register
#define DSP_DMA_CSEI4 		0x000C8B    //Channel 4 Element Index Register
#define DSP_DMA_CSAC4 		0x000C8C    //Channel 4 Source Address Counter Register
#define DSP_DMA_CDAC4 		0x000C8D    //Channel 4 Destination Address Counter Register
#define DSP_DMA_CDEI4 		0x000C8E    //Channel 4 Destination Element Index
#define DSP_DMA_CDFI4 		0x000C8F    //Channel 4 Destination Frame Index

#define DSP_DMA_CSDP5 		0x000CA0    //Channel 5 Source/Destination Parameters Register
#define DSP_DMA_CCR5 			0x000CA1    //Channel 5 Control Register
#define DSP_DMA_CICR5 		0x000CA2    //Channel 5 Interrupt Control Register
#define DSP_DMA_CSR5 			0x000CA3    //Channel 5 Status Register
#define DSP_DMA_CSSA_L5 	0x000CA4    //Channel 5 Source Start Address Register LSB
#define DSP_DMA_CSSA_U5 	0x000CA5    //Channel 5 Source Start Address Register MSB
#define DSP_DMA_CDSA_L5 	0x000CA6    //Channel 5 Destination Start Address Register LSB
#define DSP_DMA_CDSA_U5 	0x000CA7    //Channel 5 Destination Start Address Register MSB
#define DSP_DMA_CEN5 			0x000CA8    //Channel 5 Element Number Register
#define DSP_DMA_CFN5 			0x000CA9    //Channel 5 Frame Number Register
#define DSP_DMA_CSFI5 		0x000CAA    //Channel 5 Frame Index Register
#define DSP_DMA_CSEI5 		0x000CAB    //Channel 5 Element Index Register
#define DSP_DMA_CSAC5 		0x000CAC    //Channel 5 Source Address Counter Register
#define DSP_DMA_CDAC5 		0x000CAD    //Channel 5 Destination Address Counter Register
#define DSP_DMA_CDEI5 		0x000CAE    //Channel 5 Destination Element Index
#define DSP_DMA_CDFI5 		0x000CAF    //Channel 5 Destination Frame Index

#define DSP_DMA_GCR_BASE 0x0008
#define DSP_DMA_GCR_FREE_ENABLE 0x0 <<2
#define DSP_DMA_GCR_FREE_DISABLE 0x1 <<2
#define DSP_DMA_GCR_MPUI_EXCL_0  0x0 <<1
#define DSP_DMA_GCR_MPUI_EXCL_1  0x1<<1
#define DSP_DMA_GCR_MPUI_PRIO_LOW 0x0
#define DSP_DMA_GCR_MPUI_PRIO_HI  0x1

#define DSP_DMA_GSCR_BASE 0x0001    //DINDXMD set 1 to fullfill DOUBLEINDEX
#define DSP_DMA_GSCR_DINDXMD_COMPATIBILITY 0x0
#define DSP_DMA_GSCR_DINDXMD_ENHANCED  0x1

#define DSP_DMA_GTCR_BASE 0x0000
#define DSP_DMA_GTCR_DTCE_DISABLE 0x0<<1
#define DSP_DMA_GTCR_DTCE_ENABLE 0x1<<1
#define DSP_DMA_GTCR_STCE_DISABLE 0x0
#define DSP_DMA_GTCR_STCE_ENABLE 0x1

#define DSP_DMA_CSDP_BASE 					0xA140  //2007/5/14 09:57U 0xA140 -> 0x0
#define DSP_DMA_CSDP_DST_SARAM 			0x0 <<9
#define DSP_DMA_CSDP_DST_DARAM 			0x1 <<9
#define DSP_DMA_CSDP_DST_EMIF 			0x2 <<9
#define DSP_DMA_CSDP_DST_PERIPHEAL 	0x3 <<9
#define DSP_DMA_CSDP_SRC_SARAM 			0x0 <<2
#define DSP_DMA_CSDP_SRC_DARAM 			0x1 <<2
#define DSP_DMA_CSDP_SRC_EMIF 			0x2 <<2
#define DSP_DMA_CSDP_SRC_PERIPHEAL 	0x3 <<2
#define DSP_DMA_CSDP_DATATYPE_8BITS  0x0
#define DSP_DMA_CSDP_DATATYPE_16BITS 0x1
#define DSP_DMA_CSDP_DATATYPE_32BITS 0x2

#define DSP_DMA_CCR_BASE 0x0000
#define DSP_DMA_CCR_DSTAMODE_CONSTANT 0x0<<14
#define DSP_DMA_CCR_DSTAMODE_POSTINCREMENT 0x1<<14
#define DSP_DMA_CCR_DSTAMODE_SINGLEINDEX 0x2<<14
#define DSP_DMA_CCR_DSTAMODE_DOUBLEINDEX 0x3<<14
#define DSP_DMA_CCR_SRCAMODE_CONSTANT 0x0<<12
#define DSP_DMA_CCR_SRCAMODE_POSTINCREMENT 0x1<<12
#define DSP_DMA_CCR_SRCAMODE_SINGLEINDEX 0x2<<12
#define DSP_DMA_CCR_SRCAMODE_DOUBLEINDEX 0x3<<12
#define DSP_DMA_CCR_ENDPROG_ENABLE 0x1<<11
#define DSP_DMA_CCR_ENDPROG_DISABLE 0x0<<11
#define DSP_DMA_CCR_REPEAT_ENABLE 0x1<<9
#define DSP_DMA_CCR_REPEAT_DISABLE 0x0<<9
#define DSP_DMA_CCR_AUTOINIT_ENABLE 0x1<<8
#define DSP_DMA_CCR_AUTOINIT_DISABLE 0x0<<8
#define DSP_DMA_CCR_EN_ENABLE 0x1<<7
#define DSP_DMA_CCR_EN_DISABLE 0x0<<7
#define DSP_DMA_CCR_PRIO_LOW 0x0<<6
#define DSP_DMA_CCR_PRIO_HI 0x1<<6

#define DSP_DMA_CICR_BASE 0x0000
#define DSP_DMA_CICR_BLOCKIE_DISABEL 0x0<<5
#define DSP_DMA_CICR_BLOCKIE_ENABEL  0x1<<5
#define DSP_DMA_CICR_LASTIE_DISABEL 0x0<<4
#define DSP_DMA_CICR_LASTIE_ENABEL  0x1<<4
#define DSP_DMA_CICR_FRAMEIE_DISABEL 0x0<<3
#define DSP_DMA_CICR_FRAMEIE_ENABEL  0x1<<3
#define DSP_DMA_CICR_HALFIE_DISABEL 0x0<<2
#define DSP_DMA_CICR_HALFIE_ENABEL  0x1<<2
#define DSP_DMA_CICR_DROPIE_DISABEL 0x0<<1
#define DSP_DMA_CICR_DROPIE_ENABEL  0x1<<1
#define DSP_DMA_CICR_TIMEOUTIE_DISABEL 0x0
#define DSP_DMA_CICR_TIMEOUTIE_ENABEL  0x1

#define DSP_DMA_CSR_BASE 0x0000
#define DSP_DMA_CSR_BLOCK_OFF 0x0<<5
#define DSP_DMA_CSR_BLOCK_ON  0x1<<5
#define DSP_DMA_CSR_LAST_OFF 0x0<<4
#define DSP_DMA_CSR_LAST_ON  0x1<<4
#define DSP_DMA_CSR_FRAME_OFF 0x0<<3
#define DSP_DMA_CSR_FRAME_ON  0x1<<3
#define DSP_DMA_CSR_HALF_OFF 0x0<<2
#define DSP_DMA_CSR_HALF_ON  0x1<<2
#define DSP_DMA_CSR_DROP_OFF 0x0<<1
#define DSP_DMA_CSR_DROP_ON  0x1<<1
#define DSP_DMA_CSR_TIMEOUT_OFF 0x0
#define DSP_DMA_CSR_TIMEOUT_ON  0x1

typedef struct _dma_port
{
    uint32  staddr;
    int16   addressing_frmIndex;
    int16   addressing_elmIndex;
} dma_port;

typedef struct _dma_channel
{
    /** Element Count */
    uint16  elmCnt;
    /** Frame count */
    uint16  frmCnt;
    int     channel_number;
} dma_channel;

typedef void (*FuncPtr_t) (void);
